import React, {useState} from 'react';
import {
  SafeAreaView,
  Text,
  TextInput,
  TouchableOpacity,
  View,
  StyleSheet,
} from 'react-native';
import {WebView} from 'react-native-webview';
import Modal from 'react-native-modal';
import captchaHtml from './captchaHtml';
const App = () => {
  const [phone, setPhone] = useState('');
  const [password, setPassword] = useState('');
  const [isWebViewVisible, setWebViewVisible] = useState(false);

  const handleLogin = () => {
    setWebViewVisible(true);
  };

  const handleMessage = (event: {nativeEvent: {data: any}}) => {
    const message = event.nativeEvent.data;
    // {"appid":"xxxx","ret":0,"ticket":"xxxxx","randstr":"@JXx"}
    console.log('captcha callback message: ', message);
    setWebViewVisible(false);
  };

  return (
    <SafeAreaView style={styles.container}>
      <View style={styles.loginContainer}>
        <Text style={styles.title}>Tencent Captcha Demo</Text>
        <TextInput
          value={phone}
          onChangeText={setPhone}
          placeholder="phone"
          keyboardType="phone-pad"
          style={styles.input}
        />
        <TextInput
          value={password}
          onChangeText={setPassword}
          placeholder="password"
          secureTextEntry
          style={styles.input}
        />
        <TouchableOpacity onPress={handleLogin} style={styles.loginButton}>
          <Text style={styles.loginButtonText}>Login</Text>
        </TouchableOpacity>
      </View>
      <Modal
        key={isWebViewVisible ? 'visible' : 'hidden'}
        isVisible={isWebViewVisible}
        backdropColor="transparent"
        backdropOpacity={0}
        style={styles.modalStyle}>
        {isWebViewVisible && (
          <WebView
            source={{
              html: captchaHtml,
              baseUrl: 'https://turing.captcha.qcloud.com', // 使用腾讯验证码的域名作为 baseUrl
              // If you have an online page, please use URI attributes
              // uri: 'https://a.com/captcha.html'
            }}
            style={styles.webView}
            onMessage={handleMessage}
            scalesPageToFit={true}
            automaticallyAdjustContentInsets={true}
            scrollEnabled={false}
          />
        )}
      </Modal>
    </SafeAreaView>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: '#ffffff',
  },
  loginContainer: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    padding: 20,
  },
  title: {
    fontSize: 24,
    fontWeight: 'bold',
    color: '#006eff',
    marginBottom: 40,
  },
  input: {
    width: '100%',
    height: 50,
    borderColor: '#006eff',
    borderWidth: 1,
    borderRadius: 5,
    paddingHorizontal: 10,
    marginBottom: 15,
  },
  loginButton: {
    width: '100%',
    height: 50,
    backgroundColor: '#006eff',
    justifyContent: 'center',
    alignItems: 'center',
    borderRadius: 5,
  },
  loginButtonText: {
    fontSize: 18,
    color: '#ffffff',
  },
  modalStyle: {
    margin: 0,
    alignItems: 'center',
    justifyContent: 'center',
  },
  webView: {
    backgroundColor: 'transparent',
    width: 360,
    height: 360,
  },
});

export default App;
