// captchaHtml.js
const captchaHtml = `
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body {
      background-color: transparent;
      margin: 0;
      padding: 0;
    }
  </style>
  <title>Tencent Captcha</title>
  <script src="https://ca.turing.captcha.qcloud.com/TCaptcha-global.js"></script>
</head>

<body>

  <script type="text/javascript">
    function globalCallback(res) {
      if (window.ReactNativeWebView) {
        // Communication with APP
        window.ReactNativeWebView.postMessage(JSON.stringify(res));
      }

    }
    // captcha js error callback
    function errorCallback() {
      globalCallback({
        ret: -1,
        randstr: '@' + Math.random().toString(36).substr(2),
        ticket: '',
        errorCode: 1001,
        errorMessage: 'jsload_error',
      });
    }
    window.onload = function () {
      try {
        const sdkOptions = {
          needFeedBack: false,
          enableDarkMode: false,
		  // Do you need loading and mask?
		  loading:false,
          ready: function (size) {
            console.log('ready size:', JSON.stringify(size));
          }
        };
        const captcha = new TencentCaptcha('189955849', globalCallback, sdkOptions);
        captcha.show();
      } catch (error) {
        errorCallback();
      }
    }

  </script>

</body>

</html>
`;

export default captchaHtml;
